package gov.va.med.mhv.health.converter;

import gov.va.med.mhv.health.dto.ImmunizationDTO;
import gov.va.med.mhv.health.dto.ImmunizationReactionDTO;
import gov.va.med.mhv.health.enums.ReactionsEnumeration;
import gov.va.med.mhv.health.model.Immunization;
import gov.va.med.mhv.health.model.ImmunizationReaction;

import java.util.ArrayList;
import java.util.List;

public class ImmunizationConverter {
	
	
	public static ImmunizationDTO  convertImmunizationDomain( Immunization immunization ){
		ImmunizationDTO dto = new ImmunizationDTO();
		dto.setComments(immunization.getComments());
		dto.setDateReceived(immunization.getDateReceived());
		dto.setImmunizationId(immunization.getId());
		dto.setOtherVaccine(immunization.getOtherVaccine());
		dto.setReactionTypeCode(immunization.getReactionTypeCode());
		dto.setUserprofileId(immunization.getUserprofileId());
		dto.setVaccinationMethod(immunization.getVaccinationMethod());
		dto.setVaccinationTypeCode(immunization.getVaccinationTypeCode());
		setReactionDTOS(dto,immunization);
		return dto;
	}
	
	
	private static void setReactionDTOS(ImmunizationDTO dto, Immunization immunization) {
		List<ImmunizationReaction> reactions =immunization.getReactions();
		if(reactions != null){
			for(ImmunizationReaction reaction : reactions){
				if(reaction.getReactionTypeCode().equals(ReactionsEnumeration.HLS.toString())){
					dto.setChills(true);
				}
				if(reaction.getReactionTypeCode().equals(ReactionsEnumeration.DRRHA.toString())){
					dto.setDiarrhea(true);
				}
				if(reaction.getReactionTypeCode().equals(ReactionsEnumeration.DRWSNS.toString())){
					dto.setDrowsiness(true);
				}
				if(reaction.getReactionTypeCode().equals(ReactionsEnumeration.DM.toString())){
					dto.setDryMouth(true);
				}
				if(reaction.getReactionTypeCode().equals(ReactionsEnumeration.DRNS.toString())){
					dto.setDryNose(true);
				}
				if(reaction.getReactionTypeCode().equals(ReactionsEnumeration.HVS.toString())){
					dto.setHives(true);
				}
				if(reaction.getReactionTypeCode().equals(ReactionsEnumeration.IWE.toString())){
					dto.setItchingWateryEyes(true);
				}
				if(reaction.getReactionTypeCode().equals(ReactionsEnumeration.LBP.toString())){
					dto.setLowBloodPressure(true);
				}
				if(reaction.getReactionTypeCode().equals(ReactionsEnumeration.NSAVMT.toString())){
					dto.setNausea(true);
				}
				if(reaction.getReactionTypeCode().equals(ReactionsEnumeration.RSH.toString())){
					dto.setRash(true);
				}
				//ImmunizationReactionDTO reactionDTO = new ImmunizationReactionDTO();
				//reactionDTO.setImmunizationReactionId(reaction.getId());
				//reactionDTO.setReactionTypeCode(reaction.getReactionTypeCode());
				//dtos.add(reactionDTO);
			}
		}

		
		
		
		
		
		List<ImmunizationReactionDTO> dtos = new ArrayList<ImmunizationReactionDTO>();
		if(reactions != null){
			for(ImmunizationReaction reaction : reactions){
				ImmunizationReactionDTO reactionDTO = new ImmunizationReactionDTO();
				reactionDTO.setImmunizationReactionId(reaction.getId());
				reactionDTO.setReactionTypeCode(reaction.getReactionTypeCode());
				dtos.add(reactionDTO);
			}
		}
		dto.setReactions(dtos);
	}


	public static Immunization convertImmunizationDTO(ImmunizationDTO dto){
		Immunization immunization = new Immunization();
		immunization.setComments(dto.getComments());
		immunization.setDateReceived(dto.getDateReceived());
		immunization.setId(dto.getImmunizationId());
		immunization.setOplock(0);
		immunization.setOtherVaccine(dto.getOtherVaccine());
		immunization.setReactionTypeCode(dto.getReactionTypeCode());
		immunization.setUserprofileId(dto.getUserprofileId());
		immunization.setVaccinationMethod(dto.getVaccinationMethod());
		immunization.setVaccinationTypeCode(dto.getVaccinationTypeCode());
		setReactions(immunization,dto);
		return immunization;
	}
	
	
	private static void setReactions(Immunization immunization,	ImmunizationDTO dto) {
		List<ImmunizationReaction> reactions =new ArrayList<ImmunizationReaction>();
		
		if(dto.getChills()){
			ImmunizationReaction reaction = new ImmunizationReaction();
			reaction.setImmunization(immunization);
			reaction.setOplock(0);
			reaction.setReactionTypeCode(ReactionsEnumeration.HLS.toString());
			reactions.add(reaction);
		}
		if(dto.getDiarrhea()){
			ImmunizationReaction reaction = new ImmunizationReaction();
			reaction.setImmunization(immunization);
			reaction.setOplock(0);
			reaction.setReactionTypeCode(ReactionsEnumeration.DRRHA.toString());
			reactions.add(reaction);
		}
		if(dto.getDrowsiness()){
			ImmunizationReaction reaction = new ImmunizationReaction();
			reaction.setImmunization(immunization);
			reaction.setOplock(0);
			reaction.setReactionTypeCode(ReactionsEnumeration.DRWSNS.toString());
			reactions.add(reaction);
		}
		if(dto.getDryMouth()){
			ImmunizationReaction reaction = new ImmunizationReaction();
			reaction.setImmunization(immunization);
			reaction.setOplock(0);
			reaction.setReactionTypeCode(ReactionsEnumeration.DM.toString());
			reactions.add(reaction);
		}
		if(dto.getDryNose()){
			ImmunizationReaction reaction = new ImmunizationReaction();
			reaction.setImmunization(immunization);
			reaction.setOplock(0);
			reaction.setReactionTypeCode(ReactionsEnumeration.DRNS.toString());
			reactions.add(reaction);
		}
		if(dto.getHives()){
			ImmunizationReaction reaction = new ImmunizationReaction();
			reaction.setImmunization(immunization);
			reaction.setOplock(0);
			reaction.setReactionTypeCode(ReactionsEnumeration.HVS.toString());
			reactions.add(reaction);
		}
		
		if(dto.getItchingWateryEyes()){
			ImmunizationReaction reaction = new ImmunizationReaction();
			reaction.setImmunization(immunization);
			reaction.setOplock(0);
			reaction.setReactionTypeCode(ReactionsEnumeration.IWE.toString());
			reactions.add(reaction);
		}
		if(dto.getLowBloodPressure()){
			ImmunizationReaction reaction = new ImmunizationReaction();
			reaction.setImmunization(immunization);
			reaction.setOplock(0);
			reaction.setReactionTypeCode(ReactionsEnumeration.LBP.toString());
			reactions.add(reaction);
		}
		if(dto.getNausea()){
			ImmunizationReaction reaction = new ImmunizationReaction();
			reaction.setImmunization(immunization);
			reaction.setOplock(0);
			reaction.setReactionTypeCode(ReactionsEnumeration.NSAVMT.toString());
			reactions.add(reaction);
		}
		if(dto.getRash()){
			ImmunizationReaction reaction = new ImmunizationReaction();
			reaction.setImmunization(immunization);
			reaction.setOplock(0);
			reaction.setReactionTypeCode(ReactionsEnumeration.RSH.toString());
			reactions.add(reaction);
		}
		immunization.setReactions(reactions);
	}


	public static List<ImmunizationDTO>  convertImmunizationRecords( List<Immunization> immunizations ){
		List<ImmunizationDTO> dtos = new ArrayList<ImmunizationDTO>();
		for(Immunization immunization : immunizations){
			ImmunizationDTO dto = convertImmunizationDomain(immunization);
			dtos.add(dto);
		}
		return dtos;
	}

}
